/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.game.gamemode;

import dev.doctor4t.wathe.api.GameMode;
import dev.doctor4t.wathe.api.WatheRoles;
import dev.doctor4t.wathe.cca.GameRoundEndComponent;
import dev.doctor4t.wathe.cca.GameTimeComponent;
import dev.doctor4t.wathe.cca.GameWorldComponent;
import dev.doctor4t.wathe.cca.PlayerShopComponent;
import dev.doctor4t.wathe.cca.ScoreboardRoleSelectorComponent;
import dev.doctor4t.wathe.client.gui.RoleAnnouncementTexts;
import dev.doctor4t.wathe.game.GameConstants;
import dev.doctor4t.wathe.game.GameFunctions;
import dev.doctor4t.wathe.util.AnnounceWelcomePayload;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class MurderGameMode
extends GameMode {
    public MurderGameMode(class_2960 identifier) {
        super(identifier, 10, 6);
    }

    private static int assignRolesAndGetKillerCount(@NotNull class_3218 world, @NotNull List<class_3222> players, GameWorldComponent gameComponent) {
        for (class_3222 player : players) {
            gameComponent.addRole((class_1657)player, WatheRoles.CIVILIAN);
        }
        ScoreboardRoleSelectorComponent roleSelector = (ScoreboardRoleSelectorComponent)ScoreboardRoleSelectorComponent.KEY.get((Object)world.method_14170());
        int total = roleSelector.assignKillers(world, gameComponent, players, (int)Math.floor((double)players.size() / (double)gameComponent.getKillerDividend()));
        roleSelector.assignVigilantes(world, gameComponent, players, (int)Math.floor((double)players.size() / (double)gameComponent.getVigilanteDividend()));
        return total;
    }

    @Override
    public void initializeGame(class_3218 serverWorld, GameWorldComponent gameWorldComponent, List<class_3222> players) {
        int killerCount = MurderGameMode.assignRolesAndGetKillerCount(serverWorld, players, gameWorldComponent);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new AnnounceWelcomePayload(RoleAnnouncementTexts.ROLE_ANNOUNCEMENT_TEXTS.indexOf(gameWorldComponent.isRole((class_1657)player, WatheRoles.KILLER) ? RoleAnnouncementTexts.KILLER : (gameWorldComponent.isRole((class_1657)player, WatheRoles.VIGILANTE) ? RoleAnnouncementTexts.VIGILANTE : RoleAnnouncementTexts.CIVILIAN)), killerCount, players.size() - killerCount));
        }
    }

    @Override
    public void tickServerGameLoop(class_3218 serverWorld, GameWorldComponent gameWorldComponent) {
        GameFunctions.WinStatus winStatus = GameFunctions.WinStatus.NONE;
        if (!((GameTimeComponent)GameTimeComponent.KEY.get((Object)serverWorld)).hasTime()) {
            winStatus = GameFunctions.WinStatus.TIME;
        }
        boolean civilianAlive = false;
        for (class_3222 class_32222 : serverWorld.method_18456()) {
            Integer balanceToAdd;
            if (gameWorldComponent.canUseKillerFeatures((class_1657)class_32222) && (balanceToAdd = GameConstants.PASSIVE_MONEY_TICKER.apply(serverWorld.method_8510())) > 0) {
                ((PlayerShopComponent)PlayerShopComponent.KEY.get((Object)class_32222)).addToBalance(balanceToAdd);
            }
            if (!gameWorldComponent.isInnocent((class_1657)class_32222) || GameFunctions.isPlayerEliminated((class_1657)class_32222)) continue;
            civilianAlive = true;
        }
        if (!civilianAlive) {
            winStatus = GameFunctions.WinStatus.KILLERS;
        }
        if (winStatus == GameFunctions.WinStatus.NONE) {
            winStatus = GameFunctions.WinStatus.PASSENGERS;
            for (UUID uUID : gameWorldComponent.getAllKillerTeamPlayers()) {
                if (GameFunctions.isPlayerEliminated(serverWorld.method_18470(uUID))) continue;
                winStatus = GameFunctions.WinStatus.NONE;
            }
        }
        if (winStatus != GameFunctions.WinStatus.NONE && gameWorldComponent.getGameStatus() == GameWorldComponent.GameStatus.ACTIVE) {
            ((GameRoundEndComponent)GameRoundEndComponent.KEY.get((Object)serverWorld)).setRoundEndData(serverWorld.method_18456(), winStatus);
            GameFunctions.stopGame(serverWorld);
        }
    }
}

